<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns="http://www.w3.org/1999/xhtml">

<xsl:output
	method="html"
	encoding="UTF-16"
	doctype-public="-//W3C//DTD XHTML 1.1//EN"
	doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"
	indent="yes"
	cdata-section-elements="style script"/>

<xsl:template match="/root">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-16" />
		<link rel="stylesheet" href="../css/default.css" type="text/css" media="all" charset="utf-8" />
		<link rel="stylesheet" href="../css/budgets.css" type="text/css" media="all" charset="utf-8" />
        <link rel="stylesheet" href="../css/hide-1MonthHeaderBudgets.css" type="text/css" media="all" charset="utf-8" />
		<link rel="stylesheet" href="../css/zero_states.css" type="text/css" media="all" charset="utf-8" />

		<script type="text/javascript" src="../js/jquery.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/budgetGoals.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/budgets.js" charset="utf-8"></script>
		<script type="text/javascript" src="../js/utils.js" charset="utf-8"></script>
		<script type="text/javascript">
$(BudgetsInit);
		</script>
	</head>

	<body>
		<div id="outerWrapper">
			<div id="innerWrapperBudget" class="fullWidth clearAfter">
				<a href="" class="settingsButton">Edit Budget</a>
				<h1 id="pageTitle"><xsl:value-of select="reportName"/></h1>

				<xsl:choose>
					<!-- Do we have any budget goals? -->
					<xsl:when test="count(budgetGoalsPart)">
						<xsl:apply-templates select="budgetGoalsPart"/>
					</xsl:when>

					<!-- No budget goals -->
					<xsl:otherwise>
						<xsl:call-template name="NoBudgetGoalsPresent"/>
					</xsl:otherwise>
				</xsl:choose>
			</div>
		</div>
	</body>
	</html>
</xsl:template>


<!-- Currencies -->

<xsl:template match="currencies">
	<xsl:if test="count(currency) > 1">
		<select id="currencyTypeSelect">
			<xsl:apply-templates select="currency"/>
		</select>
	</xsl:if>
</xsl:template>


<xsl:template match="currency">
	<xsl:choose>
		<xsl:when test="@selected='YES'">
			<option value="{@currencyID}" selected=""><xsl:value-of select="@title"/></option>
		</xsl:when>
		<xsl:otherwise>
			<option value="{@currencyID}"><xsl:value-of select="@title"/></option>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<!-- Budget Goals -->

<xsl:template match="budgetGoalsPart">
	<div class="clearAfter">
		<xsl:apply-templates select="budget"/>
	</div>
</xsl:template>


<xsl:template match="budget">
<!--	<select id="upcomingMonthSelect">
		<option value=""><xsl:value-of select="@title"/>&#x00A0;&#x2014;&#x00A0;<xsl:value-of select="@dateRange"/></option>
	</select>-->
	<table class="budgetHeaderTable" cellspacing="0" cellpadding="0">
	<thead>
		<tr>
		<th><h2 class="budgetDateRange"><xsl:value-of select="@dateRange"/></h2></th>
		<th class="navItemButtons">
			<a href="" class="prevItemButton"></a>
			<a href="" class="currentItemButton"></a>
			<a href="" class="nextItemButton"></a>
		</th>
		</tr>
	</thead>
	</table>

	<!-- line items -->
	<xsl:apply-templates select="budgetSection"/>
	<xsl:apply-templates select="totals"/>

</xsl:template>

<!-- Budget Sections -->

<xsl:template match="budgetSection">

	<div class="savingsGoalsTableWrapper" id="{../@quickenID}">
		<!-- This first table contains the column titles and the first 8 rows -->
		<table class="savingsGoalsTable first" cellspacing="0" cellpadding="0">
		<thead>
			<tr><th class="budgetSpacer"></th></tr>
			<tr>
				<th class="goalNameCol"><xsl:value-of select="@type"/></th>
				<th class="goalPercentHdr"><span>0%</span>100%</th>
				<th class="goalCol">Goal</th>
				<th class="resultsCol">Results</th>
			</tr>
			<tr><th class="budgetSpacer"></th></tr>
		</thead>
		<tbody>
		<!-- The last table contains a the total, if present -->
            <xsl:if test="count(@total)">
				<tr class="{@displayClass} budgetTotalRow">
					<td class="goalNameCol">Budgeted <xsl:value-of select="@type"/></td>
					<td class="goalPercentCol">
						<div>
							<xsl:choose>
								<xsl:when test="@percent > 0">
									<span class="totalPercent" style="width:{@percent}%;">&#160;&#160;<xsl:value-of select="@total"/>&#160;&#160;</span>
								</xsl:when>
								<xsl:otherwise>
									<div class="totalPercent">&#160;&#160;<xsl:value-of select="@total"/>&#160;&#160;</div>
								</xsl:otherwise>
							</xsl:choose>
						</div>
					</td>
					<td class="goalCol"><xsl:value-of select="@target"/></td>
					<td class="resultsCol"><xsl:value-of select="@remaining"/></td>
				</tr>
                <tr class="budgetTotalRowHr">
                    <td/><td/><td/><td/>
				</tr>
                <tr class="budgetTotalRowEmptyRow">
                    <td/><td/><td/><td/>
				</tr>
            </xsl:if>

			<xsl:call-template name="recursive_lineItem">
				<xsl:with-param name="start"><xsl:value-of select="1"/></xsl:with-param>
				<xsl:with-param name="end"><xsl:value-of select="9"/></xsl:with-param>
			</xsl:call-template>
		</tbody>
		</table>

		<!-- The middle table contains the main entries (if over the # that will fit in the last table) -->
		<xsl:if test="count(lineItem) &gt;= 9">
			<!-- Recursively create the remaining table with page breaks inbetween-->
			<!-- Create a table for each $increment number of bars -->
			<xsl:call-template name="recursive_budgetTable">
				<xsl:with-param name="start"><xsl:value-of select="9"/></xsl:with-param>
				<xsl:with-param name="end"><xsl:value-of select="count(lineItem)"/></xsl:with-param>
				<xsl:with-param name="increment"><xsl:value-of select="10"/></xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<xsl:if test="count(@today)">
			<div class="todayMarker">
				<div class="todayFraction"><xsl:value-of select="@todayFraction"/></div>
				<div class="vTodayMarkerOuter"></div>
				<div class="vTodayMarkerInner">Today<br/><span><xsl:value-of select="@today"/></span></div>
			</div>
		</xsl:if>
	</div>
</xsl:template>

<!-- Budget Line Items -->
<xsl:template name="recursive_budgetTable">
	<xsl:param name="start"/>
	<xsl:param name="end"/>
	<xsl:param name="increment"/>
	
	<!-- Break the pages before each of the new tables -->
	<div style="page-break-before: always; height:0px; width:100%"></div>
	
	<table id="{@quickenID}" class="savingsGoalsTable middle" cellspacing="0" cellpadding="0">
	<tbody>
		<xsl:call-template name="recursive_lineItem">
			<xsl:with-param name="start"><xsl:value-of select="$start"/></xsl:with-param>
			<xsl:with-param name="end"><xsl:value-of select="$start+$increment"/></xsl:with-param>
		</xsl:call-template>
	</tbody>
	</table>
	
	<xsl:if test="$start+$increment &lt;= $end">
		<xsl:call-template name="recursive_budgetTable">
			<xsl:with-param name="start"><xsl:value-of select="$start+$increment"/></xsl:with-param>
			<xsl:with-param name="end"><xsl:value-of select="$end"/></xsl:with-param>
			<xsl:with-param name="increment"><xsl:value-of select="$increment"/></xsl:with-param>
		</xsl:call-template>
	</xsl:if>
	
</xsl:template>

<xsl:template name="recursive_lineItem">
	<xsl:param name="start"/>
	<xsl:param name="end"/>

	<xsl:for-each select="lineItem">
		<xsl:if test="position() &gt;= $start and position() &lt; $end">
				<tr class="{@displayClass}" quickenid="{@quickenID}">
					<td class="goalNameCol">
						<xsl:apply-templates select="userTag" mode="names"/>
						<xsl:apply-templates select="categoryTag" mode="names"/>
					</td>

					<td class="goalPercentCol">
						<xsl:variable name="lineItemLinkID">lineItem_<xsl:value-of select="../../@quickenID"/>_<xsl:value-of select="@quickenID"/></xsl:variable>
						<div>
							<a href="#" class="openBudgetDetailLink" rel="{$lineItemLinkID}">
							<xsl:choose>
								<xsl:when test="@percent > 0">
									<span class="totalPercent" style="width:{@percent}%;">&#160;&#160;<xsl:value-of select="@total"/>&#160;&#160;</span>
								</xsl:when>
								<xsl:otherwise>
									<div class="totalPercent">&#160;&#160;<xsl:value-of select="@total"/>&#160;&#160;</div>
								</xsl:otherwise>
							</xsl:choose>
							</a>
						</div>
						<xsl:apply-templates select="history"/>
					</td>
					<td class="goalCol"><xsl:value-of select="@target"/></td>
					<td class="resultsCol"><xsl:value-of select="@remaining"/></td>
				</tr>
		</xsl:if>
	</xsl:for-each>
</xsl:template>

<!-- "name" mode used to differentiate the display templates from the id templates -->
<xsl:template match="userTag" mode="names">
	<xsl:if test=". != ../userTag[1]">, </xsl:if>
	<xsl:value-of select="."/><xsl:text> (tag)</xsl:text>
</xsl:template>


<xsl:template match="categoryTag" mode="names">
	<xsl:if test="(. != ../categoryTag[1]) or (count(../userTag))">, </xsl:if>
	<xsl:value-of select="."/>
</xsl:template>

<!-- Budget History -->

<xsl:template match="history">
	<xsl:variable name="lineItemID">lineItem_<xsl:value-of select="../../../@quickenID"/>_<xsl:value-of select="../@quickenID"/></xsl:variable>

	<a class="openBudgetDetail" href="#" title="Display Budget History" rel="{$lineItemID}" />
	<div id="{$lineItemID}" class="budgetDetailModal {../@displayClass} clearAfter">
		<div id="inner" class="clearAfter">
			<h3>Budget History</h3>
			<div class="goalLine"></div>
            <div class="goalMarkerPoint">
				<div class="goalMarker">Goal<br/>
					<span class="goalAmount"><xsl:value-of select="../@target"/></span>
				</div>
			</div>
			<div class="goalPercent" style="display: none;"><xsl:value-of select="@goalPercent"/></div>
			<xsl:apply-templates select="year"/>
		</div>
	</div>
</xsl:template>


<xsl:template match="year">
	<xsl:variable name="yearClass">
		<xsl:choose>
			<xsl:when test="1 = position()">budgetYear first</xsl:when>
			<xsl:otherwise>budgetYear</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<div class="{$yearClass}">
		<ul>
			<xsl:apply-templates select="month"/>
		</ul>
		<span class="year"><xsl:value-of select="@name"/></span>
	</div>
</xsl:template>


<xsl:template match="month">
	<!-- apply templates matching all nodes two up from us (so up three, then all child nodes) to create our list of cat and tag quicken id's -->
	<xsl:variable name="monthTagList">
		<xsl:apply-templates select="../../../child::node()" mode="ids"/>
	</xsl:variable>

	<li class="{@displayClass}">
		<a href="#" class="budgetItemLink" quickenids="{$monthTagList}" date="{@name} 01, {../@name}">
			<span class="month"><xsl:value-of select="@name"/></span> <span class="bar" style="height:{@percent}%;"></span>
		</a>
		<div class="budgetItemAmount">
			<xsl:value-of select="@total"/>
			<div class="budgetItemAmountPoint"></div>
		</div>
	</li>
</xsl:template>

<!-- Templates used in creating the detail quicken id lists, mode "ids" differentiates from name templates -->
<xsl:template match="userTag" mode="ids">
	<xsl:if test=". != ../userTag[1]">, </xsl:if>
	<xsl:value-of select="@quickenID"/>
</xsl:template>


<xsl:template match="categoryTag" mode="ids">
	<xsl:if test="(. != ../categoryTag[1]) or (count(../userTag))">, </xsl:if>
	<xsl:value-of select="@quickenID"/>
</xsl:template>


<!-- No Budget Goals Present -->

<xsl:template name="NoBudgetGoalsPresent">
    <table class="budgetHeaderTable" cellspacing="0" cellpadding="0">
        <thead>
            <tr>
                <th><h2 class="budgetDateRange"><xsl:value-of select="@dateRange"/></h2></th>
                <th class="navItemButtons">
                    <a href="" class="currentItemButton"></a>
                    <a href="" class="nextItemButton"></a>
                </th>
            </tr>
        </thead>
    </table>
	<div class="zeroStateCont">
		<p>You haven't added any categories to this budget.</p>
		<a class="buttonLink addCategoryTags" href="#" title="Get Started">Get Started</a>
	</div>
</xsl:template>

<!-- Net Totals Section -->

<xsl:template match="totals">
	<div class="netTotals">
		<table class="netTotalsBox" cellspacing="0" cellpadding="0">
			<thead>
				<tr>
					<th class="goalNameCol">Summary</th>
					<th class="goalCol">Budgeted</th>
					<th class="actualCol">Actual</th>
					<th class="resultsCol">Results</th>
				</tr>
			</thead>
			<tr class="netSubTotal">
				<td class="netItem">Budgeted Income: </td>
				<td>
					<xsl:choose>
						<xsl:when test="incomeTarget[@sign='negative']">
							<div class="netValue netNegative"><xsl:value-of select="incomeTarget"/></div>
						</xsl:when>
						<xsl:otherwise>
							<div class="netValue"><xsl:value-of select="incomeTarget"/></div>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="incomeTotal[@sign='negative']">
							<div class="netValue netNegative"><xsl:value-of select="incomeTotal"/></div>
						</xsl:when>
						<xsl:otherwise>
							<div class="netValue"><xsl:value-of select="incomeTotal"/></div>
						</xsl:otherwise>
					</xsl:choose>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="count(incomeOver)">
							<div class="netValue netGray"><xsl:value-of select="incomeOver"/> over</div>
						</xsl:when>
						<xsl:when test="count(incomeUnder)">
							<div class="netValue netNegative"><xsl:value-of select="incomeUnder"/> under</div>
						</xsl:when>
						<xsl:otherwise>
							<div class="netValue netPositive">goal met</div>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<tr class="netSubTotal">
				<td class="netItem">Budgeted Expenses: </td>
				<td>
					<xsl:choose>
						<xsl:when test="expenseTarget[@sign='negative']">
							<div class="netValue">-<xsl:value-of select="expenseTarget"/></div>
						</xsl:when>
						<xsl:otherwise>
							<div class="netValue netNegative">-<xsl:value-of select="expenseTarget"/></div>
						</xsl:otherwise>
					</xsl:choose>
					</td>
				<td>
					<xsl:choose>
						<xsl:when test="expenseTotal[@sign='negative']">
							<div class="netValue">-<xsl:value-of select="expenseTotal"/></div>
						</xsl:when>
						<xsl:otherwise>
							<div class="netValue netNegative">-<xsl:value-of select="expenseTotal"/></div>
						</xsl:otherwise>
					</xsl:choose>
					</td>
				<td>
					<xsl:choose>
						<xsl:when test="count(expenseOver)">
							<div class="netValue netNegative"><xsl:value-of select="expenseOver"/> over</div>
						</xsl:when>
						<xsl:when test="count(expenseUnder)">
							<div class="netValue netGray"><xsl:value-of select="expenseUnder"/> under</div>
						</xsl:when>
						<xsl:otherwise>
							<div class="netValue netPositive">goal met</div>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<tr class="netTotal">
				<td class="netTotalItem netItem">Net Total for <xsl:value-of select="@month"/>:</td>
				<td>
					<xsl:choose>
						<xsl:when test="netTarget[@sign='negative']">
							<div class="netTotalSummary netValue netNegative"><xsl:value-of select="netTarget"/></div>
						</xsl:when>
						<xsl:when test="netTarget = '$0'">
							<div class="netTotalSummary netValue"><xsl:value-of select="netTarget"/></div>
						</xsl:when>
						<xsl:otherwise>
							<div class="netTotalSummary netValue netPositive"><xsl:value-of select="netTarget"/></div>
						</xsl:otherwise>
					</xsl:choose>
					</td>
				<td>
					<xsl:choose>
						<xsl:when test="netTotal[@sign='negative']">
							<div class="netTotalSummary netValue netNegative"><xsl:value-of select="netTotal"/></div>
						</xsl:when>
						<xsl:when test="netTotal = '$0'">
							<div class="netTotalSummary netValue"><xsl:value-of select="netTarget"/></div>
						</xsl:when>
						<xsl:otherwise>
							<div class="netTotalSummary netValue netPositive"><xsl:value-of select="netTotal"/></div>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
		</table>
	</div>
</xsl:template>

</xsl:stylesheet>
